function fdr=svd_fdr(D,V,neigenneurons,B)

% The codebook matrix D can be represented by the chosen eigenneurons V(:,1:neigenneurons) in the subspaces obtained by SVD. 
% For each neuron, we integrate the different projection values (forming projection vector) by calculating the Euclidian 
% distance (distance statistics,DS) from the projection vector to the coordinate-wise extreme point (zero point vector).Without loss of generality,
% the larger value of the DS indicates the biological significance.

% In order to assign statistical significance and consider the general statistical problem of multiple testing when comparing
% multiple hypothesis tests simultaneously, we employ the method of FDR (Benjamini and Hochberg, 1995), the rate of expected 
% proportion of neurons falsely called significant among the neurons called significant, as multiple comparison procedure.

% The descriptions for calculating distance statistics (DS) and selecting significant neurons are detailed in paper.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[m,n]=size(D);

% 1st step: Construct the observed neuron-specific projection vector,and calculate distance statistics DS from the projection 
%           vector to zero point vector
DV=D*V(:,1:neigenneurons);% Projection of all prototype vectors from codebook matrix into SVD subspaces
DS=sqrt(sum(DV.^2,2));% Calculation of the Euclidian distance from the projection vector to zero point vector

% 2nd step: Obtain b=1, , B null reference data sets forming GN matrix Db, which are generated by randomly permuting codebook 
%           matrix D in both row-wise (within neuron) and column-wise (within array) manner.Analogously, first compute random projection 
%           vector on the chosen eigenneurons, and then calculate distance DSb.
%% Obtain null reference data sets Db
for b=1:B
    for i=1:m
        tmp=randperm(n);
        Db(i,1:n)=D(i,tmp);
    end
    for j=1:n
        tmp=randperm(m);
        Db(1:m,j)=Db(tmp,j);
    end
    % Projection of all prototype vectors from permutated codebook matrix into SVD subspaces
    DbV(1:m,1:neigenneurons,b)=Db(1:m,1:n)*V(:,1:neigenneurons);
end
%% Calculation of the Euclidian distance Edb from the projection vector DbV to zero point vector
DSb=sqrt(sum(DbV.^2,2));

% 3rd step: Assess statistical significance in terms of FDR for each neuron
%% order the distance statistics DS
[order_DS,index]=sort(DS);
%% For the ith neuron as ordered in "order_DS", define the "falsely called neuron of interest" for each of the B sets of permutations as 
%% those neurons whose order_DSb(j,b)>=order_DS(i), j=m,...,1.
for b=1:B
    order_DSb=sort(DSb(:,b));% order the distance statistics DSb
    for i=m:-1:1
        tempDS=order_DS(i);
        for j=m:-1:1
            if order_DSb(j)<=tempDS
                fnb(i,b)=m-j;% fnb(i,j,b) store the number of falsely called neurons for the b reference null distribution
                break;
            end
        end
    end
end
%% Computer the median number of falsely called neurons among the B sets of permutations, fnm, which is divided by the number of neurons 
%% called significant(i) to get tempfdr.
for i=m:-1:1
    sn=m-i+1;
    fnm=median(fnb(i,1:B),2);
    tempfdr(i)=fnm/sn;
    if tempfdr(i)>1
        tempfdr(i)=1;  
    end
end
tempfdr=tempfdr';
%% Convert to original order
fdr=zeros(m,1);
for i=1:m
    fdr(index(i),1)=tempfdr(i,1);    
end

return